<?php
$__FILE__ = __FILE__;

require_once dirname($__FILE__).'/../inc/init.php';
defined('PHP168_PATH') or die();
$systems = $core->list_systems();
$allsites = array();
$site = isset($_GET['site']) ? trim($_GET['site']) : 'mainstation';
$search_type = isset($_GET['search_type']) ? intval($_GET['search_type']) : 0;
$starttime = isset($_GET['starttime']) ? (trim($_GET['starttime'])!='' ? strtotime(trim($_GET['starttime']).' 0:0:0') : '') : '';
$endtime = isset($_GET['endtime']) ? (trim($_GET['endtime'])!='' ? strtotime(trim($_GET['endtime']).' 23:59:59') : '') : '';

$model = isset($_GET['model']) ? $_GET['model'] : '';
if(isset($systems['sites']) && $systems['sites']['enabled']) {
    $sites = $core->load_system('sites');
    $allsites = $sites->get_sites();
    $site = count($allsites)==0 || ($site && !in_array($site,array_keys($allsites))) ? 'mainstation' : (empty($site) ? 'mainstation': $site);
    $p8_select = $site && $site != 'mainstation' ? $allsites[$site]['sitename'] : '主站';
}else{
    $p8_select = "主站";
}

$pages = '';
$count = 0;
//关键字
$keyword = isset($_GET['keyword']) ? p8_stripslashes2(trim($_GET['keyword'])) : '';
$keyword = $keyword ? $keyword : (isset($_GET['word']) ? p8_stripslashes2(trim($_GET['word'])) : '');
if(!strlen($keyword)){
    include template($core,'search','index');
	exit;
}

$year = isset($_GET['year']) ? p8_stripslashes2(trim($_GET['year'])) : '';
if($year){
	$starttime = strtotime($year.'-1-1 0:0:0');
	$endtime = strtotime($year.'-12-31 23:59:59');
}
$page_url = $year_url = $this_url .'?word='. urlencode($keyword);
$page_url .= '&page=?page?';
if($year) $page_url .= '&year='.$year;
$year_url .= '&page='.$page.'&search_type='.$search_type.'&model='.$model.'&year=';
if($search_type) $page_url .= $page_url.'&search_type='.$search_type;
if($site) $page_url .= '&site=?site?';
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$page = max($page, 1);

$list = array();
$page_size = 20;
$is_sites = false;
if(isset($systems['sites']) && $systems['sites']['enabled'] && $site && $site != 'mainstation' && in_array($site,array_keys($allsites))) {
   $is_sites = true;
}
$this_system = $is_sites ? $core->load_system('sites') : $core->load_system('cms');
$this_module = $this_system->load_module('item');
$category = &$this_system->load_module('category');
if($is_sites){
	$this_system->load_site($site);
	$category->get_cache(true,$site);
}else{
    $category->get_cache();
}
$select = select();
$keyword = html_entities($keyword);

if($model){
	$models = $this_system->get_models();
	$model = $model && isset($models[$model]) ? $model : '';
	if($model) $this_module->set_model($model);
}
$T = $model ? $this_module->table : $this_module->main_table;
$T = $search_type == 2 ? $this_module->main_table : $T;
$select->from($T . ' AS i', 'i.*');
if($is_sites) $select->in('i.site', $site);
switch($search_type){
	case '1':
		$select->search('i.title', $keyword);
	break;
	case '2':
		$this_system->init_model();
		if(empty($model)){
			$this_module->set_model('article');
		}
		$select->inner_join($this_module->addon_table .' AS a', 'a.*, a.iid AS id', 'i.id = a.iid');
		$select->search('a.content', $keyword,'(');
		$select->where_or();
		$select->search('i.title', $keyword,'',')');
	break;
	case '3':
		$select->search('i.author', $keyword);
	break;
	case '4':
		$select->in('i.username', $keyword);
	break;
	case '5':
		$select->search('i.source', $keyword);
	break;
	default:		
		$select->search('i.title', $keyword,'(');
		$select->where_or();
		$select->search('i.summary', $keyword,'',')');	
}
/*
* 如果有年份，按年份
*/
if($year){
	$select->where_and();
	$fromtime = $year ? strtotime($year.'-1-1 0:0:0') : 0;
	$totime = $year ? strtotime($year.'-12-31 23:59:59') : 0;
	$select->range('i.timestamp', $fromtime, $totime);
}else{
	if($starttime || $endtime){
		$select->where_and();
		$starttime_r = $starttime == '' ? 0 : $starttime;
		$endtime_r = $endtime == '' ? 0 : $endtime;
		$select->range('i.timestamp', $starttime_r, $endtime_r);
	}
}

//取年份
$get_year = $list_year = array();
$select_year = select();
$select_year->from($T. ' AS i', 'i.timestamp');	
$select_year->order('i.timestamp DESC');
$list_year = $core->list_item($select_year,array('page' => 0));
foreach($list_year as $k => $v){
	$get_year[] = date('Y',$v['timestamp']);
}
$get_year = array_unique($get_year);
//取数据
$count = 0;
$select->order('i.timestamp DESC');
$list = $core->list_item(
    $select,
    array(
        'page' => &$page,
        'count' => &$count,
        'page_size' => $page_size
    )
);
//echo $select->build_sql();

$page_count = ceil($count / $page_size);
//分页
$pages = list_page(array(
    'count' => $count,
    'site' => $site,
    'page' => $page,
    'page_size' => $page_size,
    'url' => $page_url
));
//处理URL
foreach($list as $k => $v){
    $v['#category'] = $category->categories[$v['cid']];
    $list[$k]['url'] = $is_sites ? $this_system->site_p8_url($this_module, $v, 'view') : p8_url($this_module, $v, 'view');
	$list[$k]['frame'] = attachment_url($v['frame']);
    $list[$k]['summary'] = html_entity_decode($v['summary']);
    $list[$k]['summary'] = preg_replace('/(amp;)+/','', $list[$k]['summary']);
	$list[$k]['summary'] = str_replace($keyword,'<font color="red">'.$keyword.'</font>',$list[$k]['summary']);
	$list[$k]['title'] = str_replace($keyword,'<font color="red">'.$keyword.'</font>',$v['title']);	
    //分类名称
    $list[$k]['category_name'] = $v['#category']['name'];
    //分类地址
    $list[$k]['category_url'] = $v['#category']['url'];
}

//标签云
function getCloud( $data = array(), $minFontSize = 12, $maxFontSize = 30 )
{
    $minimumCount = min( array_values( $data ) );
    $maximumCount = max( array_values( $data ) );
    $spread = $maximumCount - $minimumCount;
    $cloudHTML = '';
    $cloudTags = array();
	$spread == 0 && $spread = 1;
    foreach($data as $tag => $count )
    {
        $size = $minFontSize + ( $count - $minimumCount )
            * ( $maxFontSize - $minFontSize ) / $spread;
        $cloudTags[] = '<a style="color:#'.randColor().';font-size: ' . floor( $size ) . 'px'
            . '" href="?word='.$tag.'" title="\'' . $tag .
            '\' 热度 ' . $count . '">'
            . htmlspecialchars( stripslashes( $tag ) ) . '</a>';
    }

    return join( "\n", $cloudTags ) . "\n";
}
function randColor(){
    $colors=array('FF0000','0000FF','FF00FF','000000','70DB93','5C3317','9F5F9F','D9D919','A67D3D','FF7F00','8E6B23','6F4242','FF7F00',
    '42426F','2F4F2F','9932CD','871F78','7093DB','32CD99','6B8E23','2F2F4F','23238E','00009C','CFB53B','6B4226','D8BFD8','CC3299','99CC32');
    $show_color = array_rand($colors, 1);
    return $colors[$show_color];
}
function shuffle_assoc($list) {
    if (!is_array($list)) return $list;
    $keys = array_keys($list);
    shuffle($keys);
    $random = array();
    foreach ($keys as $key)
        $random[$key] = $list[$key];
    return $random;
}
$listdb = $DB_master->fetch_all("select name,item_count from ".$core->TABLE_.'cms_item_tag'." ORDER BY id DESC limit 30");
foreach ($listdb as $item) {
  $keywind[$item['name']] = $item['item_count'];
}
$keywind = shuffle_assoc($keywind);

$usetime = substr(get_timer() - $P8['start_time'], 0, 7);
$LABEL_POSTFIX = array('search');
include template($core,'search','index');