<?php
defined('PHP168_PATH') or die();

class P8_Sites_farm_Controller extends P8_Controller{

function __construct(&$obj){
	parent::__construct($obj);
	
}


/**
* 添加一个模型
**/
function add(&$POST){
	
	$data = $this->valid_data($POST);
	$data['timestamp'] = P8_TIME;
	return $this->model->add($data);
}

/**
* 修改一个模型
* @param string $name 模型名称
* @param array $POST 数据
**/
function update(&$POST){
	
	$data = $this->valid_data($POST);
	$alias = $data['alias'];
	//模型名不允许修改
	unset($data['alias']);
	
	return $this->model->update($alias, $data);
}


/**
* 验证是否是正确的模型名,字段名,必须以字母开头
* @param string $name
**/
function valid_name($name){
	return preg_replace('/[^0-9a-zA-Z_]/', '', $name);
}

/**
* 验证模型数据
* @param array $POST
**/
function valid_data(&$POST){
	$data = array();
	$data['alias'] = isset($POST['alias']) ? $this->valid_name($POST['alias']) : '';
	$data['sitename'] = isset($POST['sitename']) ? html_entities($POST['sitename']) : '';
	$data['domain'] = isset($POST['domain']) ? html_entities($POST['domain']) : '';
	$data['domain'] = preg_replace('/(.*)\/$/','\1',$data['domain']);
	if($data['domain'] && (strpos($data['domain'],'http://')===false && strpos($data['domain'],'https://')===false))$data['domain'] = 'http://'.$data['domain'];
	$data['template'] = isset($POST['template']) ? html_entities($POST['template']) : '';;
	$data['status'] = empty($POST['status']) ? 0 : 1;
    $data['parent'] = empty($POST['parent']) ? 0 : intval($POST['parent']);
	$data['ipordomain'] = empty($POST['ipordomain']) ? 0 : 1;
	$data['domain'] = empty($data['ipordomain']) ? '' : $data['domain'];
	if(in_array('s.php',explode('/',$data['domain']))){
		$data['domain'] = '';
		$data['ipordomain'] = 0;
	}
	$data['config'] = $POST['config'];
    $data['config']['allow_ip']['enabled'] = isset($data['config']['allow_ip']['enabled']) ? $data['config']['allow_ip']['enabled'] : 0;
    $data['config']['allow_ip']['collectip'] = isset($data['config']['allow_ip']['collectip']) ? explode("*", trim($data['config']['allow_ip']['collectip'])) : array();
    $data['config']['allow_ip']['collectip'] = array_filter(array_map('trim',$data['config']['allow_ip']['collectip']));
    $data['config']['allow_ip']['beginip'] = isset($data['config']['allow_ip']['beginip']) ? trim($data['config']['allow_ip']['beginip']) : '';
    $data['config']['allow_ip']['endip'] = isset($data['config']['allow_ip']['endip']) ? trim($data['config']['allow_ip']['endip']) : '';
    $data['config']['allow_ip']['ruleoutip'] = isset($data['config']['allow_ip']['ruleoutip']) ? explode("*", trim($data['config']['allow_ip']['ruleoutip'])) : array();
    $data['config']['allow_ip']['ruleoutip'] = array_filter(array_map('trim',$data['config']['allow_ip']['ruleoutip']));
    $data['config']['stop_ip']['enabled'] = isset($data['config']['stop_ip']['enabled']) ? ($data['config']['stop_ip']['enabled'] == 1 ? 1 : 0) : 0;
    $data['config']['stop_ip']['forbidip'] = isset($data['config']['stop_ip']['forbidip']) ? explode("*", trim($data['config']['stop_ip']['forbidip'])) : array();
    $data['config']['stop_ip']['forbidip'] = array_filter(array_map('trim',$data['config']['stop_ip']['forbidip']));
    $data['config']['stop_ip']['beginip'] = isset($data['config']['stop_ip']['beginip']) ? trim($data['config']['stop_ip']['beginip']) : '';
    $data['config']['stop_ip']['endip'] = isset($data['config']['stop_ip']['endip']) ? trim($data['config']['stop_ip']['endip']) : '';
    $data['config'] = empty($data['config']) ? '' : serialize($data['config']);
	return $data;
}



/**
* 删除字段
* @param int $id 字段ID
**/
function delete_field($id){
	$id = filter_int($id);
	$ids = implode(',', $id);
	
	if(empty($ids)) return false;
	
	$cond = "id IN ($ids)";
	
	return $this->model->delete_field($cond);
}

function init_site($site, $init, $item){
    if($item=='category'){
         //复制栏目
        $category= &$this->model->system->load_module('category');
        $category->get_cache(true, $init);
        $this->model->init_site_category($site, $category->top_categories);
        $category->cache(false);
        return 'site';
    }elseif($item=='site'){
         $this->model->init_site($site,$init);
        return 'menu';
    }elseif($item=='menu'){
         $this->model->init_menu($site,$init);
        return 'label';
    }elseif($item=='label'){
         $this->model->init_site_label($site,$init);
        return 'item';
    } elseif($item=='item'){
        define('P8_CLUSTER',1);
        $this->model->init_site_item($site,$init);
        return 'letter';
    } elseif($item=='letter'){
        return 'done';
    }     

}

}
