<?php
defined('PHP168_PATH') or die();

$this_system->check_manager($ACTION) or message('no_privilege');

if(REQUEST_METHOD == 'GET'){

$MODEL = '';

if(isset($_REQUEST['model'])) $this_system->init_model();

$MODEL && load_language($this_module, $MODEL);

$page_url = $this_router .'-'. $ACTION .'?';

$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$page = max($page, 1);
$cid = isset($_GET['cid']) ? intval($_GET['cid']) : 0;
$keyword = isset($_GET['keyword']) ? ltrim($_GET['keyword']) : '';
$keyword = $keyword ? $keyword : (isset($_GET['word']) ? ltrim($_GET['word']) : '');
$username = isset($_GET['username']) ? trim($_GET['username']) : '';
$verifier = isset($_GET['verifier']) ? trim($_GET['verifier']) : '';
$desc = empty($_GET['order']) ? ' DESC' : ' ASC';
$id = isset($_GET['id']) ? filter_int(explode(',', $_GET['id'])) : '';
$word = urlencode($keyword);

if(isset($_GET['verified'])){
	$verified = intval($_GET['verified']);
	$T = $verified == 1 ? $this_module->main_table : $this_module->unverified_table;
	
}else{
	$verified = 1;
	$T = $this_module->main_table;
}
$class[abs($verified)]='class="over"';
/*
$page_url .= '&verified='. $verified;
$page_url .= '&model='. $MODEL;
$page_url .= '&cid='. $cid;
$page_url .= '&word='. urlencode($keyword);
$page_url .= '&page=?page?';
*/
$page_url = $this_url .'?';
$page_url = 'javascript:request_item(?page?)';

$select = select();


$category = &$this_system->load_module('category');
$category->get_cache();

if($verified == 1){
	if($MODEL){
		$select->from($this_module->table .' AS i', 'i.*');
	}else{
		$select->from($this_module->main_table .' AS i', 'i.*');
	}
}else{
	$select->from($T .' AS i', 'i.*');
	$select->in('i.verified', $verified);
}

$select->in('i.site', $this_system->SITE);
if($id){
	$select->in('i.id', $id);	
}else{
	if($cid){
		$category->get_cache();
		$ids = array($cid) + $category->get_children_ids($cid);
		
		$select->in('i.cid', $ids);
		$select->order('i.timestamp'.$desc);
	}else{
		$select->order('i.id'.$desc);
	}
	if(strlen($keyword)){
		$select->search('i.title', $keyword);
	}
	if(strlen($username)){
		$select->in('i.username', $username);
	}
	if(strlen($verifier)){
		$select->in('i.verifier', $verifier);
	}
}

//$select->order('i.id DESC');

//所有模型
$models = $this_system->get_models();

$count = 0;
//echo $select->build_sql();
//取数据
$list = $core->list_item(
	$select,
	array(
		'page' => &$page,
		'count' => &$count,
		'page_size' => 20,
		'ms' => 'master'
	)
);
foreach($list as $k => $v){
		$list[$k]['url'] = $STATIC_URL.'/s.php/'.$this_system->SITE.'/item-view-id-'.$v['id'];
		$list[$k]['url'] .= $verified == 1? '' : '?verified=0';
		$list[$k]['title'] = p8_cutstr($list[$k]['title'],90);
        $list[$k]['verifier'] = isset($list[$k]['verifier']) ? $list[$k]['verifier'] : '';
}
//分页
$pages = list_page(array(
	'count' => $count,
	'page' => $page,
	'page_size' => 20,
	'url' => $page_url
));

$allsites = $this_system->get_sites();
$sitename = !empty($allsites[$this_system->SITE]['sitename']) ? $allsites[$this_system->SITE]['sitename']  : '';
$site_domain = !empty($allsites[$this_system->SITE]['domain']) ? $allsites[$this_system->SITE]['domain']  : $this_system->controller;
include template($this_module, 'verify');
	
}else if(REQUEST_METHOD == 'POST'){
	//只提供AJAX调用
	
	$id = isset($_POST['id']) ? $_POST['id'] : array();
	$value = isset($_POST['value']) ? intval($_POST['value']) : 0;
	$id or message('no_such_item');
	
	$id = filter_int($id);
	$id or exit('[]');
	
	$verified = isset($_POST['verified']) && $_POST['verified'] == 1 ? 1 : 0;
	//退稿理由
	$push_back_reason = isset($_POST['push_back_reason']) ? html_entities(from_utf8($_POST['push_back_reason'])) : '';
	
	$T = $value == 1 ? $this_module->unverified_table : $this_module->main_table;
	$T = $verified ? $this_module->main_table : $this_module->unverified_table;
	
	$cond = $T .'.id IN ('. implode(',', $id) .')';
	$ret = $this_controller->verify(array(
		'where' => $cond,
		'value' => $value,
		'verified' => $verified,
		'push_back_reason' => $push_back_reason
	))or exit('[]');
	exit(jsonencode($ret));
}
