<?php
defined('PHP168_PATH') or die();

class P8_Integrate_sso{

var $core;
var $CONFIG;
var $db;

function __construct(&$core){
	$this->core = &$core;
	
	isset($core->CONFIG['integration']['config']) or die('error-没有正确配置单点登录!');

	$this->CONFIG = &$core->CONFIG['integration']['config'];
	
}

function P8_Integrate_sso(&$core){
	$this->__construct($core);
}

/**
 用户登录
  @param  string $username   - 用户名
*/
function login($username){

	$data = get_member($username);
	if(empty($data)){
		$this->register($username);
        $data = get_member($username);
	}
    $member = $this->core->load_module('member');
    $member->_login($data, '');
    return $username;
	
	
}

function logout(){

	
}
function delete_member($ids){
	return true;
}

function passwd($username, $password, $old_password = ''){
	return 0;
}

/**
 注册
  @param  string $username - 注册用户名
  @param  string $password - 注册密码(md5)
  @param  string $email	   - 邮箱
  @return int 注册用户uid
  -1 用户名不合法
  -2 用户名己存在
  -3 email不合法
  -4 email被注册
*/
function register($username, $password='', $email=''){

	
	if(($status = $this->check_username($username)) != 0){
		return $status;
	}
    
    if($email && ($status = $this->check_email($email)) != 0){
		return $status;
	}
	
	
	$data = array(
		'username' => $username,
		'password' => $password?$password:md5(rand_str(6)),
		'email' => $email?$email:$username."@xx.com"
	);
	$result = $this->core->DB_master->fetch_one("select id from {$this->core->member_table} order by id desc limit 1");
	if($result){		
		return $result['id']+1;;
	}
	
	return -4;
}

function check_username($username){
	//没整合
	if(!preg_match('/^\w{4,}/', $username)){
		return -1;
	}
	
	$member = &$this->core->load_module('member');
	global $IS_ADMIN;
	if(!empty($member->CONFIG['reg_disallow_username']) && !($IS_ADMIN || defined('P8_CLUSTER'))){
		$disallow = trim($member->CONFIG['reg_disallow_username']);
		$tmp = array_filter(explode('|', $disallow));
		$disallow = implode('|', $tmp);
		
		if(preg_match('/^('. $disallow .')/i', $username)){
			return -1;
		}
	}
	
	return get_member($username) ? -2 : 0;
}

}