<?php
defined('PHP168_PATH') or die();

/**
* 查看内容
* @language [cms/item/global.php]
**/

//页面缓存参数
$PAGE_CACHE_PARAM['ttl'] = empty($this_module->CONFIG['view_page_cache_ttl']) ? 0 : $this_module->CONFIG['view_page_cache_ttl'];
page_cache($PAGE_CACHE_PARAM);

//读取数据
if($verified){
	//己审核
	$select = select();
	$select->from($this_module->addon_table .' AS a', 'a.*');
	$select->inner_join($this_module->table .' AS i', 'i.*', 'i.id = a.iid');
	$select->in('i.id', $id);
	$select->order('a.page ASC');
	$select->limit($page -1, 1);
	
	$data = array_merge($core->select($select, array('single' => true)), $data);
}else{
	//未审核的数据
	$select = select();
	$select->from($this_module->unverified_table, 'data');
	$select->in('id', $id);
	$_data = $core->select($select, array('single' => true));
	$_data or message('no_such_item');
	
	$_data = unserialize($_data['data']);
	$data = array_merge($_data['addon'], $_data['item'], $_data['main']);
	unset($_data);
}

//格式化数据
$this_module->format_data($data);

$title = '';

$category = &$this_system->load_module('category');

$category->get_cache();
$cid = &$data['cid'];
$CAT = $category->fetch_one($cid);
$cats = $category->get_parents($cid);

$data['#category'] = &$CAT;

/**
*上一篇与下一篇,
**/
$nextdb = $core->DB_slave->fetch_one("SELECT id,title,html_view_url_rule,timestamp FROM $this_module->table WHERE id<'$id' AND cid='$data[cid]' ORDER BY id DESC LIMIT 1");
if(!empty($nextdb)){
	$nextdb['subject'] = p8_cutstr($nextdb['title'],20);
	$nextdb['#category'] = &$CAT;
	$nextdb['url'] = p8_url($this_module,$nextdb,'view');
}

$backdb = $core->DB_slave->fetch_one("SELECT id,title,html_view_url_rule,timestamp FROM $this_module->table WHERE id>'$id' AND cid='$data[cid]' ORDER BY id ASC LIMIT 1");
if(!empty($backdb)){
	$backdb['subject'] = p8_cutstr($backdb['title'],20);
	$backdb['#category'] = &$CAT;
	$backdb['url'] = p8_url($this_module,$backdb,'view');
}

//初始化标签
$LABEL_POSTFIX = array();
//如果分类有自己的标签后缀
if($CAT['type'] == 2 && !empty($CAT['label_postfix'])) array_push($LABEL_POSTFIX, $CAT['label_postfix']);
//如果内容有自己的标签后缀
if(!empty($data['label_postfix'])) array_push($LABEL_POSTFIX, $data['label_postfix']);


//如果有追加内容
$pages = $data['pages'] > 1 ? 
	list_page(array(
		'count' => $data['pages'],
		'page' => $page,
		'page_size' => 1,
		'url' => p8_url($this_module, $data, 'view', false)
	)) :
	'';



//分类自定义的内容页模板
include template($this_module, empty($data['template']) ? $CAT['view_template'] : $data['template']);

//保存页面缓存
page_cache();
