<?php
defined('PHP168_PATH') or die();

class P8_Sites_farm_Controller extends P8_Controller{

function __construct(&$obj){
	parent::__construct($obj);
	
}

function P8_Sites_farm_Controller(&$obj){
	$this->__construct($obj);
}

/**
* 添加一个模型
**/
function add(&$POST){
	
	$data = $this->valid_data($POST);
	$data['timestamp'] = P8_TIME;
	return $this->model->add($data);
}

/**
* 修改一个模型
* @param string $name 模型名称
* @param array $POST 数据
**/
function update(&$POST){
	
	$data = $this->valid_data($POST);
	$alias = $data['alias'];
	//模型名不允许修改
	unset($data['alias']);
	
	return $this->model->update($alias, $data);
}


/**
* 验证是否是正确的模型名,字段名,必须以字母开头
* @param string $name
**/
function valid_name($name){
	return preg_replace('/[^0-9a-zA-Z_]/', '', $name);
}

/**
* 验证模型数据
* @param array $POST
**/
function valid_data(&$POST){
	$data = array();
	$data['alias'] = isset($POST['alias']) ? $this->valid_name($POST['alias']) : '';
	$data['sitename'] = isset($POST['sitename']) ? html_entities($POST['sitename']) : '';
	$data['domain'] = isset($POST['domain']) ? html_entities($POST['domain']) : '';
	$data['domain'] = preg_replace('/(.*)\/$/','\1',$data['domain']);
	if($data['domain'] && (strpos($data['domain'],'http://')===false && strpos($data['domain'],'https://')===false))$data['domain'] = 'http://'.$data['domain'];
	$data['template'] = isset($POST['template']) ? html_entities($POST['template']) : '';;
	$data['status'] = empty($POST['status']) ? 0 : 1;
	$data['ipordomain'] = empty($POST['ipordomain']) ? 0 : 1;
	$data['config'] = empty($POST['config']) ? '' : serialize($POST['config']);
	return $data;
}



/**
* 删除字段
* @param int $id 字段ID
**/
function delete_field($id){
	$id = filter_int($id);
	$ids = implode(',', $id);
	
	if(empty($ids)) return false;
	
	$cond = "id IN ($ids)";
	
	return $this->model->delete_field($cond);
}

function init_site($site, $init, $item){
    if($item=='category'){
         //复制栏目
        $category= &$this->model->system->load_module('category');
        $category->get_cache(true, $init);
        $this->model->init_site_category($site, $category->top_categories);
        $category->cache(false);
        return 'site';
    }elseif($item=='site'){
         $this->model->init_site($site,$init);
        return 'menu';
    }elseif($item=='menu'){
         $this->model->init_menu($site,$init);
        return 'label';
    }elseif($item=='label'){
         $this->model->init_site_label($site,$init);
        return 'item';
    } elseif($item=='item'){
        define('P8_CLUSTER',1);
        $this->model->init_site_item($site,$init);
        return 'letter';
    } elseif($item=='letter'){
        return 'done';
    }     

}

}
