<?php
defined('PHP168_PATH') or die();

/**
* 数据过滤,将option中的选项存到数据库,同时也作SQL解析用
**/

//作用域
$system = isset($_POST['system']) ? $_POST['system'] : '';
$module = isset($_POST['module']) ? $_POST['module'] : '';


if($system != 'core' && !get_system($system)){
	message('no_such_system');
}

if($module && !get_module($system, $module)){
	message('no_such_module');
}

//数据源模块信息
$_POST['source_system'] = $this_system->name;
$_POST['source_module'] = $this_module->name;
//标签类型为模块数据
$_POST['type'] = 'module_data';

$controller = &$core->controller($LABEL);

$option = isset($_POST['option']) && is_array($_POST['option']) ? $_POST['option'] : array();

//标签通用部分,把验证好的数据覆盖原来的数据
$option = $controller->valid_module_data_option($option) + $option;
unset($option['order_by_desc']);
$option['var_fields'] = array();


//是否开启sphinx搜索功能
!empty($option['sphinx']) && $option['sphinx']['enabled'] = 1;

//分类
$option['department'] = empty($_POST['department']) ? array() : $_POST['department'];
$option['type'] = empty($_POST['dtype']) ? array() : $_POST['dtype'];

//开始构造select
$select = select();
$select->from($this_module->table .' AS i', 'i.*');
//$select->in('i.vefify', 1);
if(!$this_module->CONFIG['display_model'])
    $select->in('i.undisplay', 0);

//非指定ID
if(empty($option['ids'])){

		if($option['department']){
			$select->in('i.department',$option['department']);
		}
		if($option['type']){
			$select->in('i.type',$option['type']);
		}

}else{

	//指定了ID其余的条件会被忽略

	$option['ids'] = filter_int(explode(',', $option['ids']));
	$select->in('i.id', $option['ids']);
}
//是否推荐
if($option['recommend']) $select->in('i.recommend', 1);

//排序
$str = $comma = '';
foreach($option['order_by'] as $field => $desc){
	$str .= $comma . $field .($desc ? ' DESC' : ' ASC');
	$comma = ',';
}

if($str){
	$select->order($str);
	$option['order_by_string'] = $str;
}

//限制
$select->limit(0, $option['limit']);
