<?php
defined('PHP168_PATH') or die();

class P8_Sites extends P8_System{

var $_models;	//单个模型的数组
var $models;	//全部模型
var $model;		//当前模型
var $MODEL;		//当前模型名称

var $_sites;
var $sites;	//全部站点
var $site;		//当前站点
var $SITE;		//当前站点名称
var $domain;		//当前站点名称
var $controller;		//当前站点名称
var $siteurl;		//当前站点名称
var $suv;		//当前站点名称序列

var $is_main_verifier;
var $is_category_verifier;
var $is_guest;
var $item_table;
var $category_table;
var $log_table;
var $_category;
var $index_files;

function __construct(&$core, $name){
	$this->core = &$core;
	parent::__construct($name);
	
	$this->is_category_verifier = array();
	$this->is_main_verifier = false;
	$this->is_guest = false;
	$this->_models = $this->_category = array();
	$this->index_files = array(
		1 => 'index.html',
		2 => 'index.shtml',
		3 => 'index.htm',
	);
	
	$this->log_table = $this->TABLE_ .'log';
	$this->item_table = $this->TABLE_ .'item';
	$this->category_table = $this->TABLE_ .'category';
    $this->sites = $this->get_sites();
	$this->init_site();
	
}

function P8_Sites(&$core, $name){
	$this->__construct($core, $name);
}

function init_site($name='',$set=true){

	if(!empty($name))
		$SITE = $name;
	elseif(!empty($_POST['site'])){
		$SITE =  basename($_POST['site']);
	}
	elseif(!empty($_GET['site'])){
		$SITE =  basename($_GET['site']);
	}
	elseif(get_cookie('site')!==null){
		$SITE =  basename(get_cookie('site'));
	}
	else{
		$SITE = '';
	}
	if($SITE){
		if($set)set_cookie('site',$SITE,0);
		$this->site = &$this->get_site($SITE);
		if($this->site){
			$this->SITE = $SITE;
			$this->suv = md5($SITE);
			$this->domain = $this->get_site_domain($SITE);
			$this->controller = $this->get_site_controller($SITE);
			$this->siteurl = $this->core->CONFIG['url'].'/s.php/'.$SITE;
			$base_domain = substr_count($this->domain, '.') > 1 ? substr($this->domain, strpos($this->domain, '.') +1) : $this->domain;
			$this->CONFIG['base_domain']=$base_domain;
		}
	}
}
function load_site($name){
	$sdata = $this->get_site($name);
	if(!$sdata)return null;
	$this->init_site($name);
	return $this->site;

}
function &get_site($name){
	if(!$name)return array();
    $ret = array();
	if(isset($this->sites[$name])){
		$ret = $this->core->CACHE->read($this->name .'/modules', 'farm', $name);
	}
    return $ret;
}

function get_sites(){
	if(empty($this->sites)){
		
		$this->sites = $this->core->CACHE->read($this->name .'/modules', 'farm', 'all');
	}
	if(empty($this->sites) && $this->modules['farm']['installed']){
		
		$farm = &$this->load_module('farm');
		$farm->cache();
		$this->sites = $this->core->CACHE->read($this->name .'/modules', 'farm', 'all');
	}
	return $this->sites;

}

function get_site_domain($name=''){
	if(!empty($name))
		$site = $this->get_site($name);
	else
		$site = $this->site;
		
	if(!empty($site['ipordomain']) && !empty($site['domain']))
		$link = $site['domain'];
	else
		$link = $this->core->CONFIG['url'].'/s.php/'.$site['alias'];
	
	return $link;
}

function get_site_controller($name=''){
	if(!empty($name))
		$site = $this->get_site($name);
	else
		$site = $this->site;
		
	if(!empty($site['ipordomain']) && !empty($site['domain']) && !defined('P8_MEMBER'))
		$link = preg_replace('/\/?$/','',$site['domain']).'/index.php';
	else
		$link = $this->core->CONFIG['url'].'/s.php/'.$site['alias'];
	
	return $link;
}


function site_p8_url($M, $data, $action = 'view', $first_page = true){
    if(empty($M->site['ipordomain']) && (((isset($data['#category']) && !empty($data['#category']['htmlize'])) or !empty($data['htmlize'])) or (defined('HTMLING') && HTMLING))){ 
        $M->system->url = rtrim($this->core->url,'/').'/'.$this->name.'/html/'.$this->site['alias'];$M->system->CONFIG['domain'] =  $M->system->url;
    }else{
        $M->system->url = $this->domain;
        $M->system->CONFIG['domain'] =  $this->domain;
    }
	return p8_url($M, $data, $action, $first_page);
}


function init_model(){
	global $MODEL, $this_model, $this_module;
	
	$MODEL = isset($_REQUEST['model']) ? basename($_REQUEST['model']) : '';
	$this->model = &$this->get_model($MODEL);
	if(empty($this->model)) return null;
	
	$this_model = $this->model;
	
	$this_model['path'] = $this->path .'model/'. $MODEL .'/';
	
	if(isset($this_module) && $this_module->name == 'item'){
		$this_module->set_model($MODEL);
		//加载语言包
		load_language($this_module, $MODEL);
	}
	
}

/**
* 取得sphinx索引
**/
function sphinx_indexes($models = array(), $with_delta = false){
	$_models = $this->get_models();
	if(empty($models))
		$models = $_models;
	
	//拼凑所有模型的索引
	$indexes = $comma = '';
	foreach($models as $model => $v){
		if(!$_models[$model]['enabled']) continue;
		
		$indexes .= $comma . $this->core->CONFIG['sphinx_prefix'] . $this->name .'-item-'. $model .
			($with_delta ? '; delta_'. $this->core->CONFIG['sphinx_prefix'] . $this->name .'-item-'. $model : '');
		
		$comma = '; ';
	}
	return $indexes;
}

/**
* 取得模型信息
**/
function &get_model($name){
	if(isset($this->_models[$name])){
		return $this->_models[$name];
	}
	
	$this->_models[$name] = $this->core->CACHE->read($this->name .'/modules', 'model', $name, 'serialize');
	return $this->_models[$name];
}

/**
* 取得所有模型, 仅仅是全部模型的摘要,只包含ID和名称
**/
function get_models(){
	if(empty($this->models)){
		
		$this->models = $this->core->CACHE->read($this->name .'/modules', 'model', 'models');
	}
	if(empty($this->models)){
		
		$Model = &$this->load_module('model');
		$Model->cache();
		$this->models = $this->core->CACHE->read($this->name .'/modules', 'model', 'models');
	}
	return $this->models;
}

/**
* 
**/
function &fetch_category($id, $refresh = false){
	if(isset($this->_category[$id]) && !$refresh){
		return $this->_category[$id];
	}else{
		$this->_category[$id] = $this->core->CACHE->read($this->name .'/modules/category',$this->SITE, (int)$id, 'serialize');
		return $this->_category[$id];
	}
}


function check_acl($action,$type){
	if(!in_array($type,array('check_admin_action','check_action')))return false;
	$controller=$this->core->controller($this);
	return $controller->$type($action);
}

function check_manager($action=''){
	$mysite= $this->get_manage_sites();
	if(!$mysite || !$this->SITE)return false;
	return in_array($this->SITE,$mysite);
}

function check_poster($action=''){
    if(in_array($action,array('autoverify','delete','verify','move')))return false;
    if(in_array($action,array('view','list','search','comment')))return true;
	$mysite= $this->get_poster_site();
	if(!$mysite || !$this->SITE)return false;
	return in_array($this->SITE,$mysite);
}

function get_poster_site(){
	global $IS_FOUNDER, $UID;
	if($IS_FOUNDER){
		$sites = $this->get_sites();
		$mysites = array_keys($sites);
	}else{
		$manager = $this->core->CACHE->read($this->name, '', 'manager','serialize');
		$mysites = !empty( $manager['poster'][$UID] )?$manager['poster'][$UID] : array();
	}
	return $mysites;
}

function get_manage_sites(){
	global $IS_FOUNDER, $UID,$ROLE;

	if($IS_FOUNDER){
		$sites = $this->get_sites();
		$mysites = array_keys($sites);
	}else{
		$manager = $this->core->CACHE->read($this->name, '', 'manager','serialize');
		$usites = !empty( $manager['manager'][$UID] )?$manager['manager'][$UID] : array();
		$rsites = !empty( $manager['role'][$ROLE] )?$manager['role'][$ROLE] : array();
		$mysites = array_unique (array_merge($usites,$rsites));
	}
	return $mysites;
}
function check_suv(){
	$suv = isset($_POST['suv'])?$_POST['suv']:(isset($_GET['suv'])?$_GET['suv']:'');
	if($suv && $suv!=md5($this->SITE)){
		message('suv_error');
	}

}

function isfromsites(){
   global $HTTP_REFERER;
	$sites_flag = in_array('s.php',explode('/',$HTTP_REFERER)) ? true : false;
    if(!$sites_flag){
        $sites_flag = $this->check_domain($HTTP_REFERER);
    }
	return $sites_flag;
}
function check_domain($refer){
    $detail = parse_url($refer);
    $sites = $this->get_sites();

	foreach($sites as $key=>$site){
        if(strpos($site['domain'], $detail['host'])!==false or strpos($refer,'/'.$key.'/')!==false){
            return true;
        }
    }
    return false;
}


/**
* 日志
**/
function log($data){
	global $USERNAME;
	
	$data['ip'] = P8_IP;
	$data['timestamp'] = P8_TIME;
	$data['username'] = $USERNAME;
	$data['url'] = REQUEST_URI;
	$data['site'] = $this->SITE;
	$data['request'] = $this->DB_master->escape_string(var_export($data['request'], true));
	
	return $this->DB_master->insert(
		$this->log_table,
		$data
	);
}

}
